<?php
/**
 * Theme Functions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Sterling Theme
 */

/*-----------------------------------------------------------------------------------*/
/* DO NOT EDIT THIS FILE. THE SKY MAY FALL.
/*-----------------------------------------------------------------------------------*/
// Define File Directores.
if ( function_exists( 'wp_get_theme' ) ) :
	$theme_object 	= wp_get_theme();
	$theme_name 	= $theme_object->name;
endif;

// Define Theme Constants.
define( 'TT_FUNCTIONS', 				get_template_directory() . '/framework' );
define( 'TT_GLOBAL', 					get_template_directory() . '/framework/global' );
define( 'TT_ADMIN', 					get_template_directory() . '/framework/admin' );
define( 'TT_STERLING', 					get_template_directory() . '/framework/theme-specific' );
define( 'TT_EXTENDED', 					get_template_directory() . '/framework/extended' );
define( 'TT_CONTENT', 					get_template_directory() . '/framework/content' );
define( 'TT_JS', 						get_template_directory_uri() . '/framework/js' );
define( 'TT_FRAMEWORK', 				get_template_directory_uri() . '/framework' );
define( 'TT_CSS', 						get_template_directory_uri() . '/css/' );
define( 'TT_HOME', 						get_template_directory_uri() );
define( 'TT', 							get_template_directory() . '/framework/truethemes' );
define( 'TIMTHUMB_SCRIPT',				get_template_directory_uri() . '/framework/extended/timthumb/timthumb.php' );
define( 'TIMTHUMB_SCRIPT_MULTISITE', 	get_template_directory_uri() . '/framework/extended/timthumb/timthumb.php' );

/*-----------------------------------------------------------------------------------*/
/* Fire up the Framework
/*-----------------------------------------------------------------------------------*/
/*
 * This is essentially the theme's functions.php file
 * many functions are in this file :)
 *
 */
require_once( dirname( __FILE__ ) . '/framework/framework_init.php' );
/*-----------------------------------------------------------------------------------*/
/* WP_DEBUG + PHP Error Reporting
/*-----------------------------------------------------------------------------------*/
//Some plugins such as wpcu3er will disable PHP error reporting, 
//therefore we must make sure it is turn on if WP_DEBUG is set to true.
if(defined('WP_DEBUG') == 1 || WP_DEBUG == true){
$error_setting = ini_get("display_errors");
	if($error_setting == '0'){
		ini_set('display_errors', '1');
	}
}
//if PHP error reporting is enabled we will only ALLOW PHP fatal error, syntax error, parse errors etc to show only.
$php_error_setting = ini_get("display_errors");
	if($php_error_setting == '1'){
	    //reference to http://www.php.net/manual/en/errorfunc.constants.php
		error_reporting(E_ALL & ~E_STRICT & ~E_NOTICE & ~E_WARNING & ~ E_DEPRECATED & ~ E_USER_NOTICE);
}
/*-----------------------------------------------------------------------------------*/
/* Automatic Plugin Updates (https://kernl.us/documentation)
/*-----------------------------------------------------------------------------------*/
if(is_admin()){ //do this only in admin
	require 'theme_update_check.php';
	$licence_key = get_option('st_item_purchase_code');
	//uncomment to see license key
	//print_r($licence_key);
	if(!empty($licence_key)){
		$MyUpdateChecker = new ThemeUpdateChecker(
		    'Sterling',
		    'https://kernl.us/api/v1/theme-updates/56f5758f20b0dbfb4eaa1da0/'
		);
		$MyUpdateChecker->purchaseCode = $licence_key;
	}
}
?>