<?php
/*-----------------------------------------------------------------------------------*/
/* DO NOT EDIT THIS FILE. THE SKY MAY FALL.
/*-----------------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------*/
/* Fire up the theme.
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'truethemes_sterling_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function truethemes_sterling_setup() {

	// Make theme available for translation.
	load_theme_textdomain( 'tt_theme_framework', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	// Let WordPress manage the document title.
	add_theme_support( 'title-tag' );

	// Enable support for Post Thumbnails on posts.
	add_theme_support( 'post-thumbnails' , array( 'post' ) );

	// Enable support for Post Formats.
	add_theme_support( 'post-formats', array( 'image', 'video', 'audio', 'quote', 'gallery' ) );

	// Allow shortcodes inside widgets
	add_filter('widget_text', 'do_shortcode');

	// Remove junk from head.
	remove_action( 'wp_head', 'rsd_link' );
	remove_action( 'wp_head', 'wlwmanifest_link' );
	remove_action( 'wp_head', 'wp_generator' );
	remove_action( 'wp_head', 'feed_links_extra' );
	remove_action( 'wp_head', 'feed_links' );
	remove_action( 'wp_head', 'index_rel_link' );
	remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 );
	remove_action( 'wp_head', 'start_post_rel_link', 10, 0 );
	remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );
	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	remove_action( 'admin_print_styles', 'print_emoji_styles' );
	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
	remove_action( 'wp_print_styles', 'print_emoji_styles' );
	remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
	remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
	remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );

	// Set content width in pixels.
	if ( ! isset( $content_width ) ) $content_width = 960;

	// Disable branding notice -> one-click-importer plugin.
	add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

	// WooCommerce
	if ( class_exists( 'woocommerce' ) ):
		require_once( TT_EXTENDED . '/woocommerce.php' );
		add_theme_support( 'woocommerce' );
		add_theme_support( 'post-thumbnails' , array( 'post','product' ) );
		add_theme_support( 'wc-product-gallery-zoom' );
    	add_theme_support( 'wc-product-gallery-lightbox' );
    	add_theme_support( 'wc-product-gallery-slider' );
	endif;

	// This theme uses wp_nav_menu() in two locations.
	add_theme_support( 'nav-menus' );
	register_nav_menus( array(
		'Main Menu'    => __( 'Main Menu', 'tt_theme_framework' ),
		'Footer Menu'  => __( 'Footer Menu', 'tt_theme_framework' ),
	) );
}
endif;
add_action( 'after_setup_theme', 'truethemes_sterling_setup' );
/*-----------------------------------------------------------------------------------*/
/* Enqueue the theme's CSS
/*-----------------------------------------------------------------------------------*/
/*
 * @since 2.6.2
 *
 * enqueue CSS instead of using wp_head.
 * function added to child theme to allow us
 * to call child-theme's CSS last.
 *
 */
function enqueue_sterling_css() {

	if ( ! function_exists( 'sterling_child_theme_enqueue_styles' ) ) {

		$primary_style         =  get_option('st_main_scheme');
		$secondary_style       =  get_option('st_secondary_scheme');
		$mobile_style          =  get_option('st_responsive');

		//default style.css
		wp_enqueue_style( 'style', get_template_directory_uri() . '/style.css' );

		//primary color css
		wp_enqueue_style( 'primary-color', TT_CSS . $primary_style .'.css', array(), NULL);

		//secondary color css
		if( 'default' != $secondary_style ) :
			wp_enqueue_style( 'secondary-color', TT_CSS . $secondary_style .'.css', array(), NULL);
		endif;

		//font-awesome
		wp_enqueue_style( 'font-awesome', TT_CSS .'_font-awesome.css', array(), NULL);

		//woocommerce
		if ( class_exists( 'woocommerce' ) ) :
			wp_enqueue_style( 'woocommerce', TT_CSS . '_woocommerce.css', array(), NULL);
		endif;

		//mobile stylesheet
		if( 'false' == $mobile_style ) :
			wp_enqueue_style( 'mobile', TT_CSS . '_mobile.css', array(), NULL);
		endif;

	}; //END check for sterling_child_theme_enqueue_styles()
}
add_action ( 'wp_enqueue_scripts' , 'enqueue_sterling_css' );
/*-----------------------------------------------------------------------------------*/
/* TrueThemes Framework init
/*-----------------------------------------------------------------------------------*/
// Load Theme Specific Functions.
require_once( TT_STERLING . '/site-options.php' );
require_once( TT_STERLING . '/admin-functions.php' );
require_once( TT_STERLING . '/shortcodes.php' );
require_once( TT_STERLING . '/tinymce/tinymce.loader.php' );
require_once( TT_STERLING . '/metabox.php' );
require_once( TT_STERLING . '/javascript.php' );
require_once( TT_STERLING . '/post-types.php' );
require_once( TT_STERLING . '/taxonomy.php' );
require_once( TT_STERLING . '/navigation.php' );
require_once( TT_STERLING . '/sidebars.php' );

// Load Global Functions.
require_once( TT_GLOBAL . '/theme-functions.php' );
require_once( TT_GLOBAL . '/widgets.php' );

// Load TrueThemes Functions.
require_once( TT . '/image-thumbs.php' );
require_once( TT . '/metabox/init.php' );

// Load Admin Framework.
require_once( TT_ADMIN . '/admin-functions.php' );
require_once( TT_ADMIN . '/admin-interface.php' );

// Load Extended Functionality.
require_once( TT_EXTENDED . '/multiple_sidebars.php' );
require_once( TT_EXTENDED . '/breadcrumbs.php' );
require_once( TT_EXTENDED . '/3d-tag-cloud/wp-cumulus.php' );
require_once( TT_EXTENDED . '/twitter/latest-tweets.php' );
require_once( TT_EXTENDED . '/tgm-plugin-activation/class-tgm-plugin-activation.php');

// "Page links to" metabox
if ( ! class_exists( 'CWS_PageLinksTo' ) ) :
	require_once( TT_EXTENDED . '/page-links-to/page-links-to.php' );
endif;

// WP-Page Navi
if ( ! function_exists( 'wp_pagenavi' ) ) :
	require_once( TT_EXTENDED . '/wp-pagenavi.php' );
endif;
//check if user enables our theme contact form plugin, if yes, we use it.
$tt_formbuilder = get_option( 'st_formbuilder' );
if ( 'true' == $tt_formbuilder ) :
	require_once( TT_EXTENDED . '/grunion-contact-form/grunion-contact-form.php' );
endif;
/*-----------------------------------------------------------------------------------*/
/* Body Class Function
/*-----------------------------------------------------------------------------------*/
function tt_sterling_body_classes( $classes ) {
	$activate_sticky_mobile_menu = get_option( 'st_fix_mobile_menu' );
	$thin_sticky_header          = get_option( 'st_thin_sticky_header' );
	$thin_sticky_header_toolbar  = get_option( 'st_thin_sticky_header_toolbar' );
	$color_interface             = get_option( 'st_color_interface_elements' );
	

	if( $activate_sticky_mobile_menu == 'true' ) { $classes[] = 'sterling-sticky-mobile'; }
	if( $thin_sticky_header          == 'true' ) { $classes[] = 'sterling-short-sticky'; }
	if( $thin_sticky_header_toolbar  == 'true' ) { $classes[] = 'sterling-short-sticky-toolbar'; }
	if( $color_interface             == 'true' ) { $classes[] = 'sterling-color-interface'; }
    
    return $classes;
	}
add_filter( 'body_class', 'tt_sterling_body_classes' );
/*-----------------------------------------------------------------------------------*/
/* JetPack + Contact Form
/*-----------------------------------------------------------------------------------*/
/*
 * since vesion 2.6.4
 * removed check for specific modules (causing PHP error)
 * now display when JetPack class exists
 *
 */
function tt_jetpack_contact_form_notice() {
$message = '
<div class="notice notice-warning is-dismissible"> 
	<p>Sterling has detected the JetPack Contact Form enabled on this website. To ensure proper functioning please disable Sterling\'s contact form if you prefer to use JetPack\'s contact form.<br /><br /><strong>Sterling Settings:</strong> <a href="'.admin_url("themes.php?page=siteoptions").'">Appearance > Site Options</a> > Forms</p>
</div>';
echo $message;
}
if( class_exists( 'Jetpack' ) && Jetpack::is_module_active( 'contact-form' ) ) {
		if( current_user_can('administrator')){ //show only to admin and not subscribers
			add_action( 'admin_notices','tt_jetpack_contact_form_notice' );
		}
}
/*-----------------------------------------------------------------------------------*/
/* Add Welcome Page (Appearance > Sterling Welcome)
/*-----------------------------------------------------------------------------------*/
add_action('admin_menu', 'add_sterling_welcome_page');
function add_sterling_welcome_page() {
	add_theme_page('Welcome', 'Sterling Welcome', 'edit_theme_options', 'sterling-welcome', 'sterling_render_about_page');
}
function sterling_render_about_page() {
	require_once( TT_STERLING . '/sterling-welcome.php');
}
//add redirection
function sterling_page_welcome_redirect() {
	$theme_name = get_current_theme();
	if( $theme_name == 'Sterling' ) {
		wp_redirect( admin_url( 'admin.php?page=sterling-welcome' ) );
	}
}
//enable redirect on activation.
add_action( 'after_switch_theme', 'sterling_page_welcome_redirect' );
/*-----------------------------------------------------------------------------------*/
/* Register Custom Taxonomies
/*-----------------------------------------------------------------------------------*/
//Slider Taxonomy
function truethemes_sterling_slider_taxonomy() {
	register_taxonomy(
		'sterling-slider-category',
		'slider',
		array(
			'label'        => __('Categories' , 'tt_theme_framework'),
			'sort'         => true,
			'hierarchical' => true,
			'args'         => array( 'orderby' => 'term_order' ),
			'rewrite'      => array( 'slug'    => 'sterling-slider-category' )
		)
	);
}
add_action( 'init', 'truethemes_sterling_slider_taxonomy' );
/*-----------------------------------------------------------------------------------*/
/* Sticky Menu
/*-----------------------------------------------------------------------------------*/
/*
* function to hook jQuery to footer to activate sticky menu according to site option setting.
*/
if ( ! function_exists( 'tt_hook_sticky_menu' ) ) :

function tt_hook_sticky_menu() {
	$activate_sticky_menu = get_option('st_fix_header_and_menubar');
	
	if( $activate_sticky_menu == 'true' ){
		wp_enqueue_script( 'scrollwatch', TT_JS .'/scrollWatch.js', array(), NULL, true );
		echo "\n<script type='text/javascript'>jQuery(document).ready(function(){truethemes_StickyMenu();});</script>\n";
	}
}
endif;
add_action( 'wp_footer' , 'tt_hook_sticky_menu' );
/*-----------------------------------------------------------------------------------*/
/* TGM Plugin Activation (LayerSlider, etc)
/*-----------------------------------------------------------------------------------*/
add_action( 'tgmpa_register', 'truethemes_register_required_plugins' );
function truethemes_register_required_plugins() {
	/**
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(
		// Include Premium Plugins:
		array(
			'name'     				=> 'LayerSlider', // The plugin name
			'slug'     				=> 'LayerSlider', // The plugin slug (typically the folder name)
			'source'   				=> 'http://s3.truethemes.net/theme-included-plugins/layersliderwp.zip', // The plugin source
			'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
			'name'     				=> 'Revolution Slider', // The plugin name
			'slug'     				=> 'revslider', // The plugin slug (typically the folder name)
			'source'   				=> 'http://s3.truethemes.net/theme-included-plugins/revslider.zip', // The plugin source
			'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		// Plugins from the WordPress Plugin Repository:
		array(
			'name' 		=> 'One Click Demo Import',
			'slug' 		=> 'one-click-demo-import',
			'required' 	=> false,
		),
		array(
			'name' 		=> 'WooCommerce',
			'slug' 		=> 'woocommerce',
			'required' 	=> false,
		),
		array(
			'name' 		=> 'MailChimp',
			'slug' 		=> 'mailchimp',
			'required' 	=> false,
		),
		array(
			'name' 		=> 'All in One SEO Pack',
			'slug' 		=> 'all-in-one-seo-pack',
			'required' 	=> false,
		),
	);
	// Change this to your theme text domain, used for internationalising strings
	$theme_text_domain = 'tt_theme_framework';
	$config = array(
		'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'themes.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => true,                    // Automatically activate plugins after installation or not.
		'message' 	   => '', 					   // Message to output right before the plugins table */
		'strings'      => array(
			'page_title'                      => __( 'Install Plugins', $theme_text_domain ),
			'menu_title'                      => __( 'Install Plugins', $theme_text_domain ),
			'installing'                      => __( 'Installing Plugin: %s', $theme_text_domain ), // %s = plugin name.
			'updating'                        => __( 'Updating Plugin: %s', $theme_text_domain ), // %s = plugin name.
			'oops'                            => __( 'Something went wrong with the plugin API.', $theme_text_domain ),
			'notice_can_install_required'     => _n_noop(
				'This theme requires the following plugin: %1$s.',
				'This theme requires the following plugins: %1$s.',
				$theme_text_domain
			), // %1$s = plugin name(s).
			'notice_can_install_recommended'  => _n_noop(
				'This theme recommends the following plugin: %1$s.',
				'This theme recommends the following plugins: %1$s.',
				$theme_text_domain
			), // %1$s = plugin name(s).
			'notice_ask_to_update'            => _n_noop(
				'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.',
				'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.',
				$theme_text_domain
			), // %1$s = plugin name(s).
			'notice_ask_to_update_maybe'      => _n_noop(
				'There is an update available for: %1$s.',
				'There are updates available for the following plugins: %1$s.',
				$theme_text_domain
			), // %1$s = plugin name(s).
			'notice_can_activate_required'    => _n_noop(
				'The following required plugin is currently inactive: %1$s.',
				'The following required plugins are currently inactive: %1$s.',
				$theme_text_domain
			), // %1$s = plugin name(s).
			'notice_can_activate_recommended' => _n_noop(
				'The following recommended plugin is currently inactive: %1$s.',
				'The following recommended plugins are currently inactive: %1$s.',
				$theme_text_domain
			), // %1$s = plugin name(s).
			'install_link'                    => _n_noop(
				'Begin installing plugin',
				'Begin installing plugins',
				$theme_text_domain
			),
			'update_link' 					  => _n_noop(
				'Begin updating plugin',
				'Begin updating plugins',
				$theme_text_domain
			),
			'activate_link'                   => _n_noop(
				'Begin activating plugin',
				'Begin activating plugins',
				$theme_text_domain
			),
			'return'                          => __( 'Return to Plugin Installer', $theme_text_domain ),
			'plugin_activated'                => __( 'Plugin activated successfully.', $theme_text_domain ),
			'activated_successfully'          => __( 'The following plugin was activated successfully:', $theme_text_domain ),
			'plugin_already_active'           => __( 'No action taken. Plugin %1$s was already active.', $theme_text_domain ),  // %1$s = plugin name(s).
			'plugin_needs_higher_version'     => __( 'Plugin not activated. A higher version of %s is needed for this theme. Please update the plugin.', $theme_text_domain ),  // %1$s = plugin name(s).
			'complete'                        => __( 'All plugins installed and activated successfully. %1$s', $theme_text_domain ), // %s = dashboard link.
			'notice_cannot_install_activate'  => __( 'There are one or more required or recommended plugins to install, update or activate.', $theme_text_domain ),
			'contact_admin'                   => __( 'Please contact the administrator of this site for help.', $theme_text_domain ),
			'nag_type'                        => 'updated', // Determines admin notice type - can only be one of the typical WP notice classes, such as 'updated', 'update-nag', 'notice-warning', 'notice-info' or 'error'. Some of which may not work as expected in older WP versions.
		),
	);
	if(current_user_can('administrator')){ //do this only for admin and not subscribers
		tgmpa( $plugins, $config );
	}
}
/*-----------------------------------------------------------------------------------*/
/* One Click Demo Importer
/*-----------------------------------------------------------------------------------*/
//@since 2.6.2
function truethemes_sterling_import_files() {
    return array(
        array(
            'import_file_name'           => 'Main Demo',
            //'categories'                 => array( 'Category 1', 'Category 2' ),
            'import_file_url'            => 'http://s3.truethemes.net.s3.amazonaws.com/demo-importer-content/sterling/sterling-default-demo-content.xml',
            'import_widget_file_url'     => 'http://s3.truethemes.net.s3.amazonaws.com/demo-importer-content/sterling/sterling-default-demo-widgets.wie',
            //'import_customizer_file_url' => 'http://www.your_domain.com/ocdi/customizer.dat',
            /* 'import_redux'               => array(
                array(
                    'file_url'    => 'http://www.your_domain.com/ocdi/redux.json',
                    'option_name' => 'redux_option_name',
                ),
            ), */
            //'import_preview_image_url'   => 'http://www.your_domain.com/ocdi/preview_import_image1.jpg',
            'import_notice'              => __( '<h3>Welcome</h3><p class="about-description">Importing demo data is the easiest way to setup your theme. It will allow you to quickly edit everything instead of creating content from scratch. Posts, pages, images, widgets, menus and other theme settings will get automatically imported. Please be patient as it may take a few minutes to complete.</p><h3>Installation</h3><ul><li>Start the Import by clicking the button below. Please click the button only one time</li><li>You\'ll receive a notification on this page once the Import has completed.</li><li>Enjoy :)</li><ul>', 'tt_theme_framework' ),
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'truethemes_sterling_import_files' );
/*-------------------------------------------------------------- 
Set Menus and Front Page
--------------------------------------------------------------*/
function truethemes_sterling_after_import_setup() {
    $main_menu    = get_term_by( 'name', 'Main Menu', 'nav_menu' );
    $footer_menu  = get_term_by( 'name', 'Footer Menu', 'nav_menu' );
    set_theme_mod( 'nav_menu_locations', array(
            'Main Menu'     => $main_menu->term_id,
            'Footer Menu'   => $footer_menu->term_id,
        )
    );
/*-------------------------------------------------------------- 
Assign front page and posts page
--------------------------------------------------------------*/
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );
    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );
}
add_action( 'pt-ocdi/after_import', 'truethemes_sterling_after_import_setup' );
/*-------------------------------------------------------------- 
Change location of the plugin page (tools.php)
--------------------------------------------------------------*/
function ocdi_plugin_page_setup( $default_settings ) {
    $default_settings['parent_slug'] = 'tools.php';
    $default_settings['page_title']  = esc_html__( 'Import Demo Data' , 'tt_theme_framework' );
    $default_settings['menu_title']  = esc_html__( 'Import Demo Data' , 'tt_theme_framework' );
    $default_settings['capability']  = 'import';
    $default_settings['menu_slug']   = 'pt-one-click-demo-import';

    return $default_settings;
}
add_filter( 'pt-ocdi/plugin_page_setup', 'ocdi_plugin_page_setup' );
?>